/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api;

import com.mojang.blaze3d.matrix.MatrixStack;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IFrameProviderInstance;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.TickableAnimation;
import net.minecraft.client.renderer.IRenderTypeBuffer;

public class Animation
extends TickableAnimation {
    private final IFrameProviderInstance provider;

    public Animation(IKeyframeProvider provider, int length) {
        this(IFrameProviderInstance.forFrameProvider(provider), length);
    }

    public Animation(IFrameProviderInstance provider, int length) {
        super(length);
        this.provider = provider;
    }

    @Override
    public void animate(AnimationStage stage, MatrixStack matrix, IRenderTypeBuffer typeBuffer, int light, int overlay) {
        if (this.provider.blocksStageAnimation(stage)) {
            return;
        }
        this.preAnimate(stage, matrix);
        float progressInterpolated = this.getInterpolatedProgress();
        IKeyframe currentFrame = this.provider.getCurrentFrame(stage, progressInterpolated);
        IKeyframe lastFrame = this.provider.getPreviousFrame(stage);
        float activeEndpoint = currentFrame.endpoint();
        float prevEndpoint = lastFrame.endpoint();
        float min = activeEndpoint - prevEndpoint;
        float stageProgress = min == 0.0f ? 1.0f : (progressInterpolated - prevEndpoint) / (activeEndpoint - prevEndpoint);
        Keyframes.processFrame(currentFrame, stageProgress, matrix);
        this.onAnimated(stage, matrix, typeBuffer, light, overlay);
    }

    @Override
    public void nextFrame(float actualProgress, float previousProgress) {
        this.provider.onAnimationProgressed(actualProgress, previousProgress, this);
    }

    public void onAnimated(AnimationStage stage, MatrixStack stack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
    }

    public void preAnimate(AnimationStage stage, MatrixStack stack) {
    }
}

